<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0 RC2
// ||              
// ||             .
// ||       (  )
// || tranlated by: arabsdesign.com
// || www.arabsdesign.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

// ############################# Resize Image #################################
function resize_image($widthsize, $heightsize, $original = 0, $nameonly = false, $savepath = '')
{
	global $imageinfo, $vba_options, $userid;

	if ($heightsize AND $widthsize)
	{
		$heightpercent = $imageinfo['height'] / $heightsize;
		$widthpercent = $imageinfo['width'] / $widthsize;
	}

	if ($heightpercent > 1 OR $widthpercent > 1)
	{
		if ($widthpercent > $heightpercent)
		{
			$shrinkage = $widthsize / $imageinfo['width'];
		}
		else
		{
			$shrinkage = $heightsize / $imageinfo['height'];
		}

		$newheight = round($shrinkage * $imageinfo['height']);
		$newwidth = round($shrinkage * $imageinfo['width']);

		if ($savepath)
		{
			$savepath = $savepath;
		}
		else if ($original)
		{
			$savepath = $imageinfo['location'];
		}
		else if ($vba_options['gallery_resizemethod'] == 2 OR ($vba_options['gallery_resizemethod'] == 1 AND in_array($imageinfo['numericaltype'], array(2, 3))))
		{
			$imageinfo['thumbname'] = $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension'];
			$savepath = $imageinfo['saveto'] . '/' . $imageinfo['thumbname'];
		}
		else
		{
			$imageinfo['thumbname'] = '';
		}

		if ($nameonly)
		{
			return $imageinfo;
		}

		// Now let's resize it
		modify_image($savepath, $newwidth, $newheight, iif($original, $vba_options['gallery_origquality'], $vba_options['gallery_thumbquality']));

		// New image info if resizing original
		if ($original == 1)
		{
			$imageinfo['width'] = $newwidth;
			$imageinfo['height'] = $newheight;
			clearstatcache();
			$imageinfo['filesize'] = @filesize($imageinfo['location']);
		}
	}
	else
	{
		// Else we're not resizing
		if (!$original AND !$imageinfo['thumbname'])
		{
			$imageinfo['thumbname'] = $imageinfo['saveas'];
		}
	}

	return $imageinfo;
}

// ########################### Resize or Change Quality #######################
function modify_image($savepath, $width, $height, $quality)
{
	global $vba_options, $imageinfo;

	switch ($vba_options['gallery_resizemethod'])
	{
		// Use GD to Resize
		case 1:
			switch ($imageinfo['numericaltype'])
			{
				// JPG Image
				case 2:
					$src_img = @imagecreatefromjpeg($imageinfo['location']);
					if ($width AND $height)
					{
						$dst_img = @imagecreatetruecolor($width, $height);
						@imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
					}
					else
					{
						$dst_img = $src_img;
					}
					@imagejpeg($dst_img, $savepath, $quality);
					break;

				// PNG Image
				case 3:
					$src_img = @imagecreatefrompng($imageinfo['location']);
					$dst_img = @imagecreate($width, $height, $quality);
					@imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
					@imagepng($dst_img, $savepath);
					break;
			}

			@imagedestroy($src_img);
			@imagedestroy($dst_img);

			break;

		// Use ImageMagick to Resize
		case 2:

			if ($quality == -1)
			{
				$quality = '';
			}

			$IMcommand = '"' . $vba_options['gallery_programpath'] . 'convert" -page ' . iif($width AND $height, '-size ' . $width . 'x' . $height. ' -geometry ' . $width . 'x' . $height) . iif($quality, ' -quality ' . $quality) . ' ' . $imageinfo['location'] . '[0] ' . $savepath;

			@system($IMcommand, $IMerror);

			if (!in_array($IMerror, array(0, 1)))
			{
				eval(print_standard_error('adv_gallery_im_error'));
				@unlink($imageinfo['location']);
			}

			break;
	}
}

// ############################# Process Upload ###############################
function process_upload($thumbcreated = false)
{
	global $DB_site, $bbuserinfo, $permissions, $vba_options, $imageinfo, $imageoptions, $customfields, $userinfo, $categoryperms, $imgtypearray, $filetypes, $userid, $username;
	static $errors;

	$userinfo['usedspace'] += $imageinfo['filesize'];
	// Make sure the user has enough space on their account
	if ($permissions['gallery_maxdiskspace'] AND $permissions['gallery_maxdiskspace'] < $userinfo['usedspace'])
	{
		$spaceremaining = $permissions['gallery_maxdiskspace'] - ($userinfo['usedspace']);
		eval(print_standard_error('adv_gallery_nodiskspace'));
	}

	$imageinfo = resize_image($vba_options['gallery_thumbsize'], $vba_options['gallery_thumbsize'], 0, true);

	// Get original image info
	if ($vba_options['gallery_saveoriginal'] AND ($imageinfo['width'] > $filetypes["$imageinfo[extension]"]['width'] OR $imageinfo['height'] > $filetypes["$imageinfo[extension]"]['height']))
	{
		$imageinfo['originalname'] = $imageinfo['shortname'] . '_original.' . $imageinfo['extension'];
		@copy($imageinfo['location'], $imageinfo['saveto'] . '/' . $imageinfo['originalname']);
		$imageinfo['originalfilesize'] = $imageinfo['filesize'];
		$imageinfo['originalwidth'] = $imageinfo['width'];
		$imageinfo['originalheight'] = $imageinfo['height'];
		// Reduce the quality if necessary
		if (!in_array($vba_options['gallery_origquality'], array(-1, 100)) AND $imageinfo['numericaltype'] != 1)
		{
			modify_image($imageinfo['saveto'] . '/' . $imageinfo['originalname'], $imageinfo['width'], $imageinfo['height'], $vba_options['gallery_origquality']);
			clearstatcache();
			$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
		}
	}

	$imageinfo = resize_image($filetypes["$imageinfo[extension]"]['width'], $filetypes["$imageinfo[extension]"]['height'], 1);

	// Watermark Image
	if ($vba_options['gallery_watermark'])
	{
		watermark_image('normal');

		if ($imageinfo['originalname'])
		{
			watermark_image('original');
		}
	}

	if (!trim($imageinfo['title']))
	{
    $imageinfo['title'] = $imageinfo['shortname'];
	}

	$valid = iif($categoryperms["$imageinfo[catid]"]['moderateimages'], 0, 1);

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_gallery_images (title, description, keywords, catid, dateline, userid, username, extension, filename, filesize, width, height, thumbname, originalname, originalfilesize, originalwidth, originalheight, valid, open) VALUES ('" . addslashes(htmlspecialchars($imageinfo['title'])) . "', '" . addslashes($imageinfo['description']) . "', '" . addslashes(htmlspecialchars($imageinfo['keywords'])) . "', '$imageinfo[catid]', '" . time() . "', '$userid', '" . htmlspecialchars(addslashes($username)) . "', '$imageinfo[extension]', '" . addslashes($imageinfo['saveas']) . "', '$imageinfo[filesize]', '$imageinfo[width]', '$imageinfo[height]', '" . addslashes($imageinfo['thumbname']) . "', '" . htmlspecialchars(addslashes($imageinfo['originalname'])) . "', '$imageinfo[originalfilesize]', '$imageinfo[originalwidth]', '$imageinfo[originalheight]', '$valid', 1)");

	$newimageid = $DB_site->insert_id();

	if ($imageoptions['favorite'])
	{
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_gallery_favorites (userid, imageid) VALUES ('$bbuserinfo[userid]', '$newimageid')");
	}

	if ($imageoptions['subscribe'])
	{
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_gallery_subscribeimage (userid, imageid) VALUES ('$bbuserinfo[userid]', '$newimageid')");
	}

	construct_customfields_sql($customfields, $newimageid);

	@chmod($imageinfo['location'], 0777);

	if ($valid)
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET imagecount = imagecount+1, lastimageid = '$newimageid', lastimageuserid = '$userid', lastimageusername = '" . addslashes($username) . "', lastimagetitle = '" . htmlspecialchars(addslashes($imageinfo['title'])) . "', lastimagedateline = '" . TIMENOW . "' WHERE catid = '$imageinfo[catid]'");
	}
	return $newimageid;
}

// ######################## Fetch Random Image Name ###########################
function fetch_random_imagename($filename, $existsarray)
{
	$randfilename = substr($filename, '', strrpos($filename, '.')) . '_' . rand(0, 999999) . '.' . substr($filename, strrpos($filename, '.') + 1);

	if (!in_array($randfilename, $existsarray))
	{
		return $randfilename;
	}
	else
	{
		fetch_random_imagename();
	}
}

// ############################# Fetch Image Info #############################
function fetch_image_info($location, $filename)
{
	global $DB_site, $vba_options, $imageinfo, $folderstring, $userid, $server, $bbuserinfo;

	$imginfo['truename'] = $filename;
	$filename = strtolower(str_replace(array(' ', '\'', '(', ')'), array('_', '', '', ''), $filename));

	$existsarray = array();
	$exists = $DB_site->query("SELECT filename, originalname, thumbname FROM " . TABLE_PREFIX . "adv_gallery_images WHERE userid = '$userid' AND (filename LIKE '" . addslashes($filename) . "%' OR thumbname LIKE '" . addslashes($filename) . "%' OR originalname LIKE '" . addslashes($filename) . "%')");
	while ($exist = $DB_site->fetch_array($exists))
	{
		$existsarray[] = $exist['filename'];
		$existsarray[] = $exist['thumbname'];
		$existsarray[] = $exist['originalname'];
	}
	if (!empty($existsarray))
	{
		$imginfo['filename'] = fetch_random_imagename($filename, $existsarray);
		if ($server['upload'])
		{
			@rename($location, $vba_options['gallery_userfolder'] . '/' . $bbuserinfo['userid'] . '/' . $imginfo['filename']);
		}
	}
	else
	{
		$imginfo['filename'] = $filename;
	}

	$imginfo['saveas'] = $imginfo['filename'];
	$imginfo['location'] = $location;

	$imginfo['saveto'] = $vba_options['gallery_filedirectory'] . $folderstring;
	$imginfo['shortname'] = substr($imginfo['filename'], '', strrpos($imginfo['filename'], '.'));
	$imginfo['extension'] = substr($imginfo['filename'], strrpos($imginfo['filename'], '.') + 1);

	$imagedata = @getimagesize($imginfo['location']);
	$imginfo['width'] = $imagedata[0];
	$imginfo['height'] = $imagedata[1];
	$imginfo['numericaltype'] = $imagedata[2];
	$imginfo['type'] = @image_type_to_mime_type($imagedata[2]);
	$imginfo['filesize'] = @filesize($imginfo['location']);

	return array_merge($imageinfo, $imginfo);
}

// ##################### Fetch Category Extension Info ########################
function fetch_cat_ext_info()
{
	global $DB_site, $imageinfo;

	$catfiletypes	= array();
	$cattypes = $DB_site->query("SELECT catid, disext FROM " . TABLE_PREFIX . "adv_gallery_categories WHERE disext != ''");
	while ($ctypes = $DB_site->fetch_array($cattypes))
	{
		$ftypes = unserialize($ctypes['disext']);

		if (!empty($ftypes))
		{
			foreach ($ftypes AS $ext => $values)
			{
				$catfiletypes["$ctypes[catid]"]["$ext"] = $values;
			}
		}
	}

	$DB_site->free_result($cattypes);
	unset($ctypes);

	$filetypes = array();
	$gettypes = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_filetypes WHERE enabled = 1");
	while ($types = $DB_site->fetch_array($gettypes))
	{
		$filetypes["$types[extension]"] = $types;
	}

	$DB_site->free_result($gettypes);
	unset($types);

	if (!empty($catfiletypes["$imageinfo[catid]"]))
	{
		foreach ($catfiletypes["$imageinfo[catid]"] AS $key => $value)
		{
			if (!$value['enabled'])
			{
				unset($filetypes["$key"]);
			}
			else
			{
				$filetypes["$key"] = $value;
			}
		}
	}
	return $filetypes;
}

// ############################### Check Image Errors #########################
function check_upload_errors()
{
	global $imageinfo, $imageinfo, $DB_site, $vba_options, $permissions, $userinfo, $filetypes, $imgtypearray, $categorycache, $catfiletypes;

	if (!isset($errors))
	{
		$errors = array();
	}

	// No catid
	if (!$imageinfo['catid'])
	{
		eval('$errors[] = "' . fetch_phrase('adv_gallery_must_choose_category', PHRASETYPEID_ERROR) . '";');
	}

	// Open for images?
	$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);
	if (!$catopts['open_for_images'] AND $imageinfo['catid'])
	{
		eval('$errors[] = "' . fetch_phrase('adv_gallery_categoryclosed', PHRASETYPEID_ERROR) . '";');
	}

	// Filesize
	if ($filetypes["$imageinfo[extension]"]['filesize'] AND $imageinfo['filesize'] > $filetypes["$imageinfo[extension]"]['filesize'])
	{
		$maxsize = make_good_size($filetypes["$imageinfo[extension]"]['filesize']);
		eval('$errors[] = "' . fetch_phrase('imagetoobig', PHRASETYPEID_ERROR) . '";');
	}

	// Extensions
	if (!in_array($imageinfo['extension'], array_keys($filetypes)) OR strstr($imageinfo['saveas'], '..'))
	{
		$tempfiletypes = &$filetypes;
		if ($categorycache["$imageinfo[catid]"]['disext'])
		{
			foreach ($tempfiletypes AS $ext => $extinfo)
			{
				if (in_array($extinfo['extensionid'], explode(',', $categorycache["$imageinfo[catid]"]['disext'])))
				{
					unset($tempfiletypes["$ext"]);
				}
			}
		}
		$allowedextensions = implode(', ', array_keys($tempfiletypes));

		eval('$errors[] = "' . fetch_phrase('adv_gallery_invalid_extension', PHRASETYPEID_ERROR) . '";');
	}

	if (!in_array($imageinfo['numericaltype'], array(2,3)) AND $vba_options['gallery_resizemethod'] == 1 AND ($imageinfo['width'] > $filetypes["$imageinfo[extension]"]['width'] OR $imageinfo['height'] > $filetypes["$imageinfo[extension]"]['height']))
	{
		$maxwidth = $filetypes["$imageinfo[extension]"]['width'];
		$maxheight = $filetypes["$imageinfo[extension]"]['height'];
		eval('$errors[] = "' . fetch_phrase('adv_gallery_imagetoolarge', PHRASETYPEID_ERROR) . '";');
	}

	// Illegal filetypes
	if (in_array($imageinfo['extension'], array_keys($imgtypearray)) AND $imgtypearray["$imageinfo[extension]"] != $imageinfo['numericaltype'])
	{
		eval('$errors[] = "' . fetch_phrase('attachbadtype', PHRASETYPEID_ERROR) . '";');
	}

	// Description
	if (strlen($imageinfo['description']) > $vba_options['gallery_desclimit'])
	{
		$desclength = number_format(strlen($imageinfo['description']));
		eval('$errors[] = "' . fetch_phrase('adv_gallery_description_toolong', PHRASETYPEID_ERROR) . '";');
	}

	return $errors;
}


// ############################## Watermark Image #############################
function watermark_image($type)
{
	global $imageinfo, $vba_options, $imgtypearray;

	switch ($type)
	{
		case 'original':
			$imglocation = $imageinfo['saveto'] . '/' . $imageinfo['originalname'];
			$imgheight = $imageinfo['originalheight'];
			$imgwidth = $imageinfo['originalwidth'];
			break;
		default:
			$imglocation = $imageinfo['location'];
			$imgheight = $imageinfo['height'];
			$imgwidth = $imageinfo['width'];
	}

	if (in_array($imageinfo['extension'], array_keys($imgtypearray)))
	{
		$logoinfo = @getimagesize($vba_options['gallery_watermark']);
		$logo['width'] = $logoinfo[0];
		$logo['height'] = $logoinfo[1];
		$logo['extension'] = substr($vba_options['gallery_watermark'], strrpos($vba_options['gallery_watermark'], '.') + 1);

		switch ($vba_options['gallery_watermark_location']{0})
		{
			case 'n':
				$placementy = 0;
				break;
			case 'm':
				$placementy = round(($imgheight - $logo['height']) / 2);
				break;
			default:
				$placementy = $imgheight - $logo['height'];
		}

		switch($vba_options['gallery_watermark_location']{1})
		{
			case 'w':
				$placementx = 0;
				break;
			case 'c':
				$placementx = round(($imgwidth - $logo['width']) / 2);
				break;
			default:
				$placementx = $imgwidth - $logo['width'];
		}

		if ($vba_options['gallery_resizemethod'] == 1)
		{
			if ($imgwidth > $logo['width'] AND $imgheight > $logo['height'] AND in_array($imageinfo['extension'], array('jpg', 'jpeg', 'png')))
			{
				$mainimage = @imagecreatefromjpeg($imglocation);
				ImageAlphaBlending($mainimage, true);

				switch ($logo['extension'])
				{
					case 'jpg':
					case 'jpeg':
						$logoimage = @imagecreatefromjpeg($vba_options['gallery_watermark']);
						break;

					case 'png':
						$logoimage = @imagecreatefrompng($vba_options['gallery_watermark']);
						break;
				}

				@imagecopy($mainimage, $logoimage, $placementx, $placementy, 0, 0, $logo['width'], $logo['height']);
				@imagejpeg($mainimage, $imglocation, 100);

				@imagedestroy($mainimage);
				@imagedestroy($logoimage);
			}
		}
		else
		{
			$IMcommand = '"' . $vba_options['gallery_programpath'] . 'composite" -quality 100 -gravity northwest -geometry +' . $placementx . '+' . $placementy . ' ' . $vba_options['gallery_watermark'] . ' ' . $$imglocation . ' ' . $imageinfo['location'];
			@system($IMcommand, $retval);
		}
	}
}

// ############################### Rotate Image ###############################
function rotate_image($imagelocation, $angle)
{
	global $vba_options;

	if ($vba_options['gallery_resizemethod'] == 1)
	{
		$tempimage = @imagecreatefromjpeg($imagelocation);
		$tempimage = @imagerotate($tempimage, $angle, '#000000');
		@imagejpeg($tempimage, $imagelocation, 100);
		@imagedestroy($tempimage);
	}
	else
	{
		$IMcommand = '"' . $vba_options['gallery_programpath'] . 'convert" -rotate ' . $angle . ' ' . $imagelocation . ' ' . $imagelocation;
		@system($IMcommand, $retval);
	}
}

// ############################## Flip Image ##################################
function flip_image($imglocation)
{
	global $flip, $vba_options;
	$imgsrc = @imagecreatefromjpeg($imglocation);
  $width = @imagesx($imgsrc);
  $height = @imagesy($imgsrc);
	$imgdest = @imagecreatetruecolor($width, $height);

	if (sizeof($flip) == 2)
	{
		$flipit = 'both';
	}
	else if (implode(',', $flip) == 'horizontal')
	{
		$flipit = 'flop';
	}
	else
	{
		$flipit = 'flip';
	}

	if ($vba_options['gallery_resizemethod'] == 1)
	{
		for ($x = 0; $x < $width; $x++)
		{
			for ($y = 0 ; $y < $height; $y++)
			{
				switch ($flipit)
				{
					case 'flop':
						@imagecopy($imgdest, $imgsrc, $width-$x-1, $y, $x, $y, 1, 1);
						break;
					case 'flip':
						@imagecopy($imgdest, $imgsrc, $x, $height-$y-1, $x, $y, 1, 1);
						break;
					case 'both':
						@imagecopy($imgdest, $imgsrc, $width-$x-1, $height-$y-1, $x, $y, 1, 1);
						break;
				}
			}
		}

		@imagejpeg($imgdest, $imglocation);
		@imagedestroy($imgsrc);
		@imagedestroy($imgdest);
	}
	else
	{
		if ($flipit == 'both')
		{
			$command = '-flip -flop';
		}
		else
		{
			$command = '-' . $flipit;
		}

		$IMcommand = '"' . $vba_options['gallery_programpath'] . 'convert" ' . $command . ' ' . $imglocation . ' ' . $imglocation;
		@system($IMcommand, $retval);
	}
}

?>